/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_JOB_IMPL_H
#define _SCE_JOB_IMPL_H
#include <assert.h>

namespace sce {
	namespace Toolkit{
		namespace NP{
			namespace Utilities {

		class iJob {
		public:
			virtual ~iJob() {}
			virtual void setResult()=0;
		};

		template<typename T> class Future;


		template<class U> class Job : public iJob {
		public:
			Job( Future<U>* _in) : m_future(_in) {
				m_future->setBusy();
			}
			~Job(){}

			U*	getData() {return & m_future->m_result;}

			Future<U>*	getFuture() {return m_future;}

			virtual void setResult()
			{
				m_future->m_errorCode = 0;
				int ret = m_future->m_sync.signalAll();
				if(ret != SCE_TOOLKIT_NP_SUCCESS) {
					assert(ret != SCE_TOOLKIT_NP_LOCK_ERROR_ALREADY_OWNED );
					assert(ret != SCE_TOOLKIT_NP_INVALID_ARGUMENT );
					m_future->m_errorCode = ret; // other error is EBUSY which indicates it's trying to be set from 2 locations
				}

			}

			void setResult(U& input)
			{
				m_future->m_result = input;
				setResult();
			}

			void setError(int err) 
			{
				m_future->m_errorCode = err;
				int ret = m_future->m_sync.signalAll();
				if(ret != SCE_TOOLKIT_NP_SUCCESS) {
					assert(ret != SCE_TOOLKIT_NP_LOCK_ERROR_ALREADY_OWNED );
					assert(ret != SCE_TOOLKIT_NP_INVALID_ARGUMENT );
					m_future->m_errorCode = ret; // other error is EBUSY which indicates it's trying to be set from 2 locations
				}

			}
		private:
			Future<U> *m_future;
		};
			}//end Utilities
		}//end NP
	}//end Toolkit
}//end sce
#endif
